﻿namespace Hims.Api.Controllers
{
    using Dapper;
    using Domain.Configurations;
    using Domain.Helpers;
    using Domain.Services;
    using Hims.Api.Models;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Shared.EntityModels;
    using Hims.Shared.Library;
    using Hims.Shared.UserModels.Filters;
    using Hims.Shared.UserModels.OBEncounter;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Shared.DataFilters;
    using Shared.Library.Enums;
    using Shared.UserModels;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using Utilities;



    /// <summary>
    /// The genetic speciality encounter controller.
    /// </summary>
    [Route("api/genetic-speciality-encounter")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class GeneticSpecialityEncounterController: BaseController
    {
        /// <summary>
        /// the genetic speciality encounter service
        /// </summary>
        private readonly IGeneticSpecialityEncounterService geneticSpecialityEncounterService;
        /// <summary>
        /// the unitOfWork
        /// </summary>
        private readonly IUnitOfWork unitOfWork;
        /// <summary>
        /// the aesHelper
        /// </summary>
        private readonly IAESHelper aesHelper;
       
        public   GeneticSpecialityEncounterController(
        IGeneticSpecialityEncounterService GeneticSpecialityEncounterService,
        IUnitOfWork unitOfWork,
        IAESHelper AESHelper)
        {
            this.geneticSpecialityEncounterService = GeneticSpecialityEncounterService;
            this.unitOfWork= unitOfWork;
            this.aesHelper= AESHelper;
        }



        /// <summary>
        /// The modify async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Authorize]
        [Route("modify")]
        [ProducesResponseType(typeof(int), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> ModifyAsync([FromBody] GeneticSpecialityEncounterModel model)
        {
           var appointmentId=Convert.ToInt32(this.aesHelper.Decode(model.EncryptedAppointmentId));
          model.AppointmentId = appointmentId;
            model=(GeneticSpecialityEncounterModel)EmptyFilter.Handler(model);
            var response = await this.geneticSpecialityEncounterService.CheckExisted(appointmentId);
            var data = response > 0 ? await this.geneticSpecialityEncounterService.UpdateAsync(model) : await geneticSpecialityEncounterService.AddAsync(model);

            return Ok(data);

        }

        /// <summary>
        /// To find genetic speciality encounter dashboard
        /// </summary>
        /// <param name="model" >
        /// The encounter filter model.
        /// </param>
        /// <returns>
        /// The encounter model.
        /// </returns>
        [HttpPost]
        [Authorize]
        [Route("find-dashboard")]
        [ProducesResponseType(typeof(IEnumerable<GeneticSpecialityEncounterModel>), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> FindDashboardAsync([FromBody] GeneticSpecialityEncounterModel model)
        {
            model = (GeneticSpecialityEncounterModel)EmptyFilter.Handler(model);
          
            var appointmentId = Convert.ToInt32(this.aesHelper.Decode(model.EncryptedAppointmentId));
            model.AppointmentId = appointmentId;
            var response = await this.geneticSpecialityEncounterService.FindDashboardAsync(model);
            if (response == null)
            {
                response = new GeneticSpecialityEncounterModel();
                response.AppointmentId = appointmentId;
                response.EncryptedAppointmentId = this.aesHelper.Encode(appointmentId.ToString());
            }
            return this.Success(response);
           
        }

    }
}
